<?php

return [
    'admin-user' => [
        'title' => 'Users',

        'actions' => [
            'index' => 'Users',
            'create' => 'New User',
            'edit' => 'Edit :name',
            'edit_profile' => 'Edit Profile',
            'edit_password' => 'Edit Password',
        ],

        'columns' => [
            'id' => 'ID',
            'last_login_at' => 'Last login',
            'first_name' => 'First name',
            'last_name' => 'Last name',
            'email' => 'Email',
            'password' => 'Password',
            'password_repeat' => 'Password Confirmation',
            'activated' => 'Activated',
            'forbidden' => 'Forbidden',
            'language' => 'Language',
                
            //Belongs to many relations
            'roles' => 'Roles',
                
        ],
    ],

    'post' => [
        'title' => 'Posts',

        'actions' => [
            'index' => 'Posts',
            'create' => 'New Post',
            'edit' => 'Edit :name',
        ],

        'columns' => [
            'id' => 'ID',
            
        ],
    ],


    'good' => [
        'title' => 'Goods',

        'actions' => [
            'index' => 'Goods',
            'create' => 'New Good',
            'edit' => 'Edit :name',
            'export' => 'Export',
        ],

        'columns' => [
            'id' => 'ID',
			'inventory_no' => 'Inv. no',
			'category' => 'Category',
            'country' => 'Country',
            'name' => 'Name',
            'price' => 'Price',
            'unit' => 'Unit',
            'spec' => 'Spec',
			'stock' => 'Stock',
            'alert_level' => 'Alert Stock Level',
			'total_price' => 'Total Price',
			'no_of_orders' => 'Total No. of Orders',
			'total_quantity_required' => 'Total Quantity Required'
        ],
    ],

    'customer' => [
        'title' => 'Customers',

        'actions' => [
            'index' => 'Customers',
            'create' => 'New Customer',
            'edit' => 'Edit :name',
        ],

        'columns' => [
            'id' => 'ID',
            'name' => 'Name',
            'address' => 'Address',
            'shop_open' => 'Shop Open',
			'shop_close' => 'Shop Close',
			'delivery_meridian' => 'Delivery AM/PM',
			'delivery_time' => 'Delivery Time',
			'phone_no' => 'Phone No.',
			'shop_open' => 'Shop Open',
			'contact_person' => 'Contact Person',
			'sales_id' => 'Sales',
			'sales_info' => 'Sales Information',
			'comment' => 'Comment',
			'district' => 'District'
        ],
    ],

     'invoice' => [
        'title' => 'Invoices',

        'actions' => [
            'index' => 'Invoices',
            'create' => 'New Invoice',
            'edit' => 'Edit :name',
            'export' => 'Export',
			'cancel_order' => 'Cancel',
			'paid' => 'Paid',
			'shipped_unpay' => 'Shipped(unpay)',
        ],

        'columns' => [
            'id' => 'ID',
            'contact' => 'Contact',
            'delivery_time' => 'Delivery time',
            'delivery_date' => 'Delivery date',
            'payment_method' => 'Payment method',
			'lump_sum' => 'Total Pay',
            'comment' => 'Comment',
            'invoice_items' => 'items',
			'customer' => 'Customer',
			'address' => 'Customer Address',
			'customer_info' => 'Customer Information',
			'sales_info' => 'Sales Information',
			'no_of_items' => 'No. of Items',
			'spec' => 'Spec',
			'no_of_print' => 'No. Of Print',
			'print_date' => 'Printing Date Time',
			'cancel_order' => 'Order Cancelled',
			'updated_at' => 'Invoice Update Date',
			'total_invoices' => 'Total No. of Invoice',
			'quantity' => 'Quantity'
        ],
    ],
	
	'invoiceItem' => [
       
        'columns' => [
            'selling_price' => 'Price',
            'quantity' => 'Quantity',
            'total_price' => 'Total Price'
        ],
    ],

    'test' => [
        'title' => 'Test',

        'actions' => [
            'index' => 'Test',
            'create' => 'New Test',
            'edit' => 'Edit :name',
        ],

        'columns' => [
            'id' => 'ID',
            'contact' => 'Contact',
            'delivery_time' => 'Delivery time',
            'delivery_date' => 'Delivery date',
            'lump_sum' => 'Lump sum',
            'payment_method' => 'Payment method',
            'comment' => 'Comment',
            
        ],
    ],

    'sale' => [
        'title' => 'Sales',

        'actions' => [
            'index' => 'Sales',
            'create' => 'New Sale',
            'edit' => 'Edit :name',
        ],

        'columns' => [
            'id' => 'ID',
            'name' => 'Name',
            'phone_no' => 'Phone no',
            
        ],
    ],

    'order' => [
        'title' => 'Orders',

        'actions' => [
            'index' => 'Orders',
            'create' => 'New Order',
            'edit' => 'Edit :name',
        ],

        'columns' => [
            'id' => 'ID',
            'customer_id' => 'Customer',
            'district' => 'District',
            'comment' => 'Comment',
			'historicalOrder' => 'Historical Order',
            'post_order' => 'Post Order',
			'updated_at' => 'Order Update Date'
        ],
    ],

	'report' => [
			'stockLevel' => 'Stock Alert',
			'dailyShipOut' => 'Ship Out',
			'customerPurchaseHist' => 'Purchase Records',
			'ship_date' => 'Ship Date',
			'todayInvoices' => 'Today Invoice',
			'todayOrders' => 'Today Orders'
			
		],
    // Do not delete me :) I'm used for auto-generation
];